//Experiment - 11
//Real time Data acquisition and plotting through external hardware interfaced through serial port. 

// This code requires serial toolbox installed on scilab.
// The code will execute only when Data acquisition hardware is connected on serial port(COM) of computer. 

clear;
clc;
close;

//s = openserial(1,"9600,n,8,1","binary","dtrdsr");
s = openserial(1,"9600,n,8,1","binary","none");
ns=input('Samples to be plotted: ');// 50
ts=input('Sampling time(sec): ');//2 sec
xpause(20000);

signal1=zeros(1,ns);
signal2=zeros(1,ns);
signal3=zeros(1,ns);
signal4=zeros(1,ns);
signal5=zeros(1,ns);
signal6=zeros(1,ns);
signal7=zeros(1,ns);
signal8=zeros(1,ns);

t=0:1*ts:ts*ns-1;
j=0;
clf()

    result = writeserial(s,"OK");//
    buf = readserial(s, [17]);
    xpause(200000);

for i=1:1:ns,   
    result = writeserial(s,"OK");//
  //  xpause(6000);//66941usec after tx will begin 
    buf = readserial(s, [17]);
    rbuf = str2code(buf);
    
    signal1(i)=abs((1/255)*(rbuf(2)-100));
    signal2(i)=abs((1/255)*(rbuf(4)-100));
    subplot(2,2,1)
    plot(t(i-j:i),signal1(i-j:i),'-r',t(i-j:i),signal2(i-j:i),'-b')
    a=gca();
    a.data_bounds=[0 -0.1;ts*ns-1 1.2];
    h = legend('Signal-1','Signal-2',2);
    xlabel('time in seconds -->')
    ylabel('parameter -->')
    title('DAS Response')
    set(gca(),"auto_clear","off")
    
    signal3(i)=abs((1/255)*(rbuf(6)-100));
    signal4(i)=abs((1/255)*(rbuf(8)-100));
    subplot(2,2,2)
    plot(t(i-j:i),signal3(i-j:i),'-k',t(i-j:i),signal4(i-j:i),'-m')
    a=gca();
    a.data_bounds=[0 -0.1;ts*ns-1 1.2];
    h = legend('Signal-3','Signal-4',2);
    xlabel('time in seconds -->')
    ylabel('parameter -->')
    title('DAS Response')
    set(gca(),"auto_clear","off")
    
    signal5(i)=abs((1/255)*(rbuf(10)-100));
    signal6(i)=abs((1/255)*(rbuf(12)-100));
    subplot(2,2,3)
    plot(t(i-j:i),signal5(i-j:i),'-r',t(i-j:i),signal6(i-j:i),'-k')
    a=gca();
    a.data_bounds=[0 -0.1;ts*ns-1 1.2];
    h = legend('Signal-5','Signal-6',2);
    xlabel('time in seconds -->')
    ylabel('parameter -->')
    title('DAS Response')
    set(gca(),"auto_clear","off")
    
    signal7(i)=abs((1/255)*(rbuf(14)-100));
    signal8(i)=abs((1/255)*(rbuf(16)-100));
    subplot(2,2,4)
    plot(t(i-j:i),signal7(i-j:i),'-m',t(i-j:i),signal8(i-j:i),'-b')
    a=gca();
    a.data_bounds=[0 -0.1;ts*ns-1 1.2];
    h = legend('Signal-7','Signal-8',2);
    xlabel('time in seconds -->')
    ylabel('parameter -->')
    title('DAS Response')
    set(gca(),"auto_clear","off")
    sleep(ts*1000);//wait for ts sec.
    j=j+1;
    clear buf
end
closeserial(s);
clear all
clc
disp("Required Data Plotted")
